package examples.entity.joined;

import java.util.ArrayList;
import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import examples.entity.joined.Coupe.BoringFactor;
import examples.entity.joined.Roadster.CoolFactor;
import examples.entity.joined.interfaces.RoadVehicleStatelessJoined;

@Stateless
public class RoadVehicleStatelessJoinedBean implements RoadVehicleStatelessJoined {
	@PersistenceContext(unitName="pu1")
	EntityManager em;
	
	public void doSomeStuff() {
		Coupe c = new Coupe();
		c.setMake("Bob");
		c.setModel("E400");
		c.setBoringFactor(BoringFactor.BORING);
		em.persist(c);
		
		Roadster r = new Roadster();
		r.setMake("Mini");
		r.setModel("Cooper S");
		r.setCoolFactor(CoolFactor.COOLEST);
		em.persist(r);
		
		Motorcycle m = new Motorcycle();
		em.persist(m);
	}

	public List getAllCars() {
		Query q = em.createQuery("SELECT c.id FROM CarJoined c");
		List ids = q.getResultList();
		ArrayList<Car> al = new ArrayList<Car>();
		for (Object o : ids) {
			al.add(em.find(Car.class,(Integer)o));
		}
		return al;
	}
}
